/* EDI_IND.C */

/* 19-dec-2000 */

/* Author: A.Graf */

#include "edi.h"

/********************************************************************/
/*                                                                  */
/*                         globale Daten                            */
/*                                                                  */
/********************************************************************/

int cx,cy,escf,autoind,rm,lm,jflag,maxl,cursorx,cursory,putsfl,ll,
    adcx,shcont,shlinnr,ply,qprint,nlqprint,pstat,infende,gargc,
    keepx,oldx,ox,Unixsave,bh=8;
long linnr,pageleng;
char huge *ga,huge *ge,huge *ta,huge *te,line[BUFLEN+10],
     huge *sma,huge *sme,huge *ama,huge *ame;
char *mfile,fndstr[160],repstr[160];
unsigned char *keytab,invers=255;
unsigned char kt0[256],kt1[256];
#ifdef GRAPHIC_FONT
unsigned char xfont[2048*3];
#endif

/********************************************************************/
/*                                                                  */
/*              betriebssystemabhaengige Funktionen                 */
/*                                                                  */
/********************************************************************/

#ifdef ST

char huge *text;
long tl;

#ifdef ENGLISH
char *open_s1="Graf's text editor    ATARI ST version";
char   *open_s2="Graf's text editor    ATARI ST version 19-dec-2000";
#endif
#ifdef GERMAN
char *open_s1="Grafs Texteditor    ATARI ST Version";
char *open_s2="Grafs Texteditor    ATARI ST Version 19-Dez-2000";
#endif

void initos() {
  tl=(long)Malloc(-1l)-16384l;
  if((text=(char huge *)malloc(tl))==0) exit(1);
  }

void endeos() {}

#define printchar(x) Cprnout(x)
#define RS1 13
#define RS2 10

#endif

#ifdef GEMDOSKEY

char huge *text;
long tl;

#ifdef ENGLISH
char *open_s1="Graf's text editor    VT52 version";
char *open_s2="Graf's text editor    VT52 version 19-dec-2000";
#endif
#ifdef GERMAN
char *open_s1="Grafs Texteditor    VT52 Version";
char *open_s2="Grafs Texteditor    VT52 Version 19-Dez-2000";
#endif

void initos() {
  tl=(long)Malloc(-1l)-16384l;
  if(tl>200000l && tl<400000l) tl=200000l;
  if(tl>=400000l) tl>>=1;
  if((text=(char *)malloc(tl))==0) exit(1);
  }

void endeos() {}

#define printchar(x) Cprnout(x)
#define RS1 13
#define RS2 10

#endif

#ifdef MS_DOS

char huge *text;
long tl;

#ifdef ENGLISH
char *open_s1="Graf's text editor    MS-DOS version";
char *open_s2="Graf's text editor    MS-DOS version 19-dec-2000";
#endif
#ifdef GERMAN
char *open_s1="Grafs Texteditor    MS-DOS Version";
char *open_s2="Grafs Texteditor    MS-DOS Version 19-Dez-2000";
#endif

void initos() {
  unsigned long i;
  for(i=640008l;i>64l*1024l;i-=1000l) {
    text=_halloc(i,1);
    if(text != NULL) {
      _hfree(text);
      text=_halloc(i,1);
      if(text != NULL) { tl=(long)i; return; }
      }
    }
#ifdef ENGLISH
  printf("Not enough memory!\n");
#endif
#ifdef GERMAN
  printf("Speicher reicht nicht!\n");
#endif
  exit(1);
  }

void endeos() { _hfree(text); }

void printchar(int x) {}

#define RS1 13
#define RS2 10

#endif

#ifdef LINUX

#define tl 4000008l
char *text;

#ifdef ENGLISH
char *open_s1="Graf\047s text editor    LINUX version";
char *open_s2="Graf\047s text editor    LINUX version 19-dec-2000";
#endif
#ifdef GERMAN
char *open_s1="Grafs Texteditor    LINUX Version";
char *open_s2="Grafs Texteditor    LINUX Version 19-Dez-2000";
#endif

void initos() { text=(char *)malloc(tl); }

void endeos() { free(text); }

void printchar(int x) {}

#define RS1 13
#define RS2 10

#endif

#ifdef OS9

#ifdef ELTECIPP
#define tl 0x15fff0
#define text ((char *)0x900a0000)
#endif

#ifdef ELTECCFG
#define tl 1000008l
char text[tl];
#endif

#ifdef OS9_VT320SCREEN
#define tl 1000008l
char text[tl];
#endif

#ifdef ENGLISH
char *open_s1="Graf's text editor    OS9 version";
char *open_s2="Graf's text editor    OS9 version     19-dec-2000";
#endif
#ifdef GERMAN
char *open_s1="Grafs Texteditor    OS9 Version";
char *open_s2="Grafs Texteditor    OS9 Version     19-Dez-2000";
#endif

int  PRINTFILE;
char PRINTCHAR;

void initos() { PRINTFILE=open("/lp",3); }

void endeos() { tsleep(0x80000200); }

#define printchar(c) PRINTCHAR=c,write(PRINTFILE,&PRINTCHAR,1)

#define RS1 13

#endif

/********************************************************************/
/*                                                                    */
/*                        unabhngige Funktionen                            */
/*                                                                    */
/********************************************************************/

#ifdef GRAPHIC_FONT
unsigned char far yfont[2048*2]={
  0,0,0,0,0,0,0,0,24,60,102,195,231,36,36,60,60,36,36,231,195,102,60,24,
  
24,28,246,131,131,246,28,24,24,56,111,193,193,111,56,24,60,153,195,231,195,153,60,0,
  
255,255,254,252,249,243,231,0,231,195,153,60,153,195,231,0,1,3,6,140,216,112,32,0,
  
126,195,211,211,219,195,195,126,24,60,60,60,126,16,56,16,24,28,22,16,16,112,240,96,
  
240,192,254,216,222,24,24,0,240,192,223,219,255,30,27,0,5,5,5,13,13,25,121,113,
  160,160,160,176,176,152,158,142,124,198,198,0,198,198,124,0,6,6,6,0,6,6,6,0,
  124,6,6,124,192,192,124,0,124,6,6,124,6,6,124,0,198,198,198,124,6,6,6,0,
  124,192,192,124,6,6,124,0,124,192,192,124,198,198,124,0,124,6,6,0,6,6,6,0,
  
124,198,198,124,198,198,124,0,124,198,198,124,6,6,124,0,0,0,60,6,126,102,60,0,
  120,96,120,96,126,24,30,0,7,15,31,24,24,16,30,23,240,248,236,4,4,4,60,84,
  17,11,13,6,7,46,57,56,4,40,216,40,208,16,224,0,0,0,0,0,0,0,0,0,
  24,24,24,24,24,0,24,0,102,102,102,0,0,0,0,0,0,108,254,108,108,254,108,0,
  24,62,96,60,6,124,24,0,0,102,108,24,48,102,70,0,56,108,56,112,222,204,118,0,
  24,24,24,0,0,0,0,0,14,28,24,24,24,28,14,0,112,56,24,24,24,56,112,0,
  0,102,60,255,60,102,0,0,0,24,24,126,24,24,0,0,0,0,0,0,48,48,96,0,
  0,0,0,126,0,0,0,0,0,0,0,0,0,24,24,0,2,6,12,24,48,96,64,0,
  60,102,110,118,102,102,60,0,24,56,24,24,24,24,126,0,60,102,6,12,24,48,126,0,
  126,12,24,12,6,102,60,0,12,28,60,108,126,12,12,0,126,96,124,6,6,102,60,0,
  60,96,96,124,102,102,60,0,126,6,12,24,48,48,48,0,60,102,102,60,102,102,60,0,
  60,102,102,62,6,12,56,0,0,24,24,0,24,24,0,0,0,24,24,0,24,24,48,0,
  6,12,24,48,24,12,6,0,0,0,126,0,0,126,0,0,96,48,24,12,24,48,96,0,
  60,102,6,12,24,0,24,0,60,102,110,106,110,96,62,0,24,60,102,102,126,102,102,0,
  
124,102,102,124,102,102,124,0,60,102,96,96,96,102,60,0,120,108,102,102,102,108,120,0,
  126,96,96,124,96,96,126,0,126,96,96,124,96,96,96,0,62,96,96,110,102,102,62,0,
  102,102,102,126,102,102,102,0,60,24,24,24,24,24,60,0,6,6,6,6,6,102,60,0,
  
102,108,120,112,120,108,102,0,96,96,96,96,96,96,126,0,198,238,254,214,198,198,198,0,
  
102,118,126,126,110,102,102,0,60,102,102,102,102,102,60,0,124,102,102,124,96,96,96,0,
  
60,102,102,102,118,108,54,0,124,102,102,124,108,102,102,0,60,102,96,60,6,102,60,0,
  
126,24,24,24,24,24,24,0,102,102,102,102,102,102,126,0,102,102,102,102,102,60,24,0,
  
198,198,198,214,254,238,198,0,102,102,60,24,60,102,102,0,102,102,102,60,24,24,24,0,
  126,6,12,24,48,96,126,0,30,24,24,24,24,24,30,0,64,96,48,24,12,6,2,0,
  120,24,24,24,24,24,120,0,16,56,108,198,0,0,0,0,0,0,0,0,0,0,254,0,
  192,96,48,0,0,0,0,0,0,0,60,6,62,102,62,0,96,96,124,102,102,102,124,0,
  0,0,60,96,96,96,60,0,6,6,62,102,102,102,62,0,0,0,60,102,126,96,60,0,
  28,48,124,48,48,48,48,0,0,0,62,102,102,62,6,124,96,96,124,102,102,102,102,0,
  24,0,56,24,24,24,60,0,24,0,24,24,24,24,24,112,96,96,102,108,120,108,102,0,
  56,24,24,24,24,24,60,0,0,0,236,254,214,198,198,0,0,0,124,102,102,102,102,0,
  0,0,60,102,102,102,60,0,0,0,124,102,102,102,124,96,0,0,62,102,102,102,62,6,
  0,0,124,102,96,96,96,0,0,0,62,96,60,6,124,0,0,24,126,24,24,24,14,0,
  0,0,102,102,102,102,62,0,0,0,102,102,102,60,24,0,0,0,198,198,214,124,108,0,
  0,0,102,60,24,60,102,0,0,0,102,102,102,62,6,124,0,0,126,12,24,48,126,0,
  14,24,24,48,24,24,14,0,24,24,24,0,24,24,24,0,112,24,24,12,24,24,112,0,
  0,96,242,158,12,0,0,0,0,24,24,52,52,98,126,0,0,60,102,96,102,60,8,56,
  102,0,0,102,102,102,62,0,12,24,0,60,126,96,60,0,24,102,0,60,6,126,62,0,
  102,0,60,6,62,102,62,0,48,24,0,60,6,126,62,0,24,24,0,60,6,126,62,0,
  0,0,60,96,96,60,8,24,24,102,0,60,126,96,60,0,102,0,60,102,126,96,60,0,
  48,24,0,60,126,96,60,0,102,0,0,56,24,24,60,0,24,102,0,56,24,24,60,0,
  96,48,0,56,24,24,60,0,102,0,24,60,102,126,102,0,24,0,24,60,102,126,102,0,
  
12,24,126,96,124,96,126,0,0,0,126,27,127,216,126,0,63,120,216,222,248,216,223,0,
  24,102,0,60,102,102,60,0,102,0,0,60,102,102,60,0,48,24,0,60,102,102,60,0,
  
24,102,0,102,102,102,62,0,48,24,0,102,102,102,62,0,102,0,102,102,102,62,6,124,
  
102,0,60,102,102,102,60,0,102,0,102,102,102,102,126,0,24,24,60,96,96,60,24,24,
  28,58,48,124,48,48,126,0,102,102,60,24,126,24,24,0,122,71,90,66,66,66,65,0,
  30,48,124,48,48,48,96,0,12,24,0,60,6,126,62,0,12,24,0,56,24,24,60,0,
  12,24,0,60,102,102,60,0,12,24,0,102,102,102,62,0,52,88,0,124,102,102,102,0,
  52,88,0,102,118,110,102,0,60,6,62,102,62,0,62,0,60,102,102,102,60,0,126,0,
  24,0,24,48,96,102,60,0,0,0,0,62,48,48,48,0,0,0,0,124,12,12,12,0,
  
198,204,216,54,107,195,134,15,198,204,216,54,110,214,159,6,24,0,24,24,24,24,24,0,
  27,54,108,216,108,54,27,0,216,108,54,27,54,108,216,0,170,0,170,0,170,0,170,0,
  
170,170,170,170,170,170,170,170,170,85,170,85,170,85,170,85,24,24,24,24,24,24,24,24,
  
24,24,24,24,248,24,24,24,24,24,24,248,24,248,24,24,102,102,102,102,230,102,102,102,
  0,0,0,0,254,102,102,102,0,0,0,248,24,248,24,24,102,102,102,230,6,230,102,102,
  
102,102,102,102,102,102,102,102,0,0,0,254,6,230,102,102,102,102,102,230,6,254,0,0,
  102,102,102,102,254,0,0,0,24,24,24,248,24,248,0,0,0,0,0,0,248,24,24,24,
  24,24,24,24,31,0,0,0,24,24,24,24,255,0,0,0,0,0,0,0,255,24,24,24,
  24,24,24,24,31,24,24,24,0,0,0,0,255,0,0,0,24,24,24,24,255,24,24,24,
  
24,24,24,31,24,31,24,24,102,102,102,102,103,102,102,102,102,102,102,103,96,127,0,0,
  0,0,0,127,96,103,102,102,102,102,102,231,0,255,0,0,0,0,0,255,0,231,102,102,
  
102,102,102,103,96,103,102,102,0,0,0,255,0,255,0,0,102,102,102,231,0,231,102,102,
  24,24,24,255,0,255,0,0,102,102,102,102,255,0,0,0,0,0,0,255,0,255,24,24,
  0,0,0,0,255,102,102,102,102,102,102,102,127,0,0,0,24,24,24,31,24,31,0,0,
  0,0,0,31,24,31,24,24,0,0,0,0,127,102,102,102,102,102,102,102,255,102,102,102,
  24,24,24,255,24,255,24,24,24,24,24,24,248,0,0,0,0,0,0,0,31,24,24,24,
  
255,255,255,255,255,255,255,255,0,0,0,0,255,255,255,255,240,240,240,240,240,240,240,240,
  15,15,15,15,15,15,15,15,255,255,255,255,0,0,0,0,0,0,118,220,200,220,118,0,
  
28,54,102,124,102,102,124,96,254,102,98,96,96,96,248,0,0,0,254,108,108,108,108,0,
  
254,102,48,24,48,102,254,0,0,30,56,108,108,108,56,0,0,0,108,108,108,108,127,192,
  0,0,126,24,24,26,12,0,60,24,60,102,102,60,24,60,0,60,102,126,102,102,60,0,
  
0,60,102,102,102,36,102,0,28,54,120,220,204,236,120,0,0,0,102,153,153,102,0,0,
  
0,3,126,206,214,214,124,192,62,112,96,126,96,112,62,0,60,102,102,102,102,102,102,0,
  0,126,0,126,0,126,0,0,24,24,126,24,24,0,126,0,48,24,12,24,48,0,126,0,
  12,24,48,24,12,0,126,0,0,14,27,27,24,24,24,24,24,24,24,24,216,216,112,0,
  24,24,0,126,0,24,24,0,0,50,76,0,50,76,0,0,56,108,56,0,0,0,0,0,
  0,0,24,60,24,0,0,0,0,0,0,24,24,0,0,0,0,7,12,24,216,120,48,0,
  56,108,108,108,108,0,0,0,56,108,24,48,124,0,0,0,0,0,60,60,60,60,0,0,
  0,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,102,126,102,102,0,0,0,
  124,102,124,102,124,0,0,0,60,102,96,102,60,0,0,0,120,102,102,102,120,0,0,0,
  126,96,124,96,126,0,0,0,126,96,124,96,96,0,0,0,60,102,96,110,54,0,0,0,
  102,102,126,102,102,0,0,0,60,24,24,24,60,0,0,0,28,12,12,108,56,0,0,0,
  102,108,112,108,102,0,0,0,48,48,48,48,62,0,0,0,102,126,126,102,102,0,0,0,
  102,118,110,110,102,0,0,0,60,102,102,102,60,0,0,0,124,102,124,96,96,0,0,0,
  60,102,102,110,62,0,0,0,124,102,124,108,102,0,0,0,60,112,12,6,56,0,0,0,
  126,24,24,24,24,0,0,0,102,102,102,102,126,0,0,0,102,102,102,60,24,0,0,0,
  102,102,126,126,102,0,0,0,102,102,24,102,102,0,0,0,102,102,24,24,24,0,0,0,
  126,12,24,48,126,0,0,0,30,24,24,24,30,0,0,0,32,48,24,12,4,0,0,0,
  120,24,24,24,120,0,0,0,16,56,108,0,0,0,0,0,0,0,0,0,0,254,0,0,
  0,0,0,0,0,0,0,0,24,24,24,0,24,0,0,0,102,102,0,0,0,0,0,0,
  102,255,102,255,102,0,0,0,16,60,112,28,120,16,0,0,0,76,24,48,100,0,0,0,
  56,68,58,68,58,0,0,0,24,24,0,0,0,0,0,0,14,28,24,28,14,0,0,0,
  112,56,24,56,112,0,0,0,102,24,126,24,102,0,0,0,0,24,126,24,0,0,0,0,
  0,0,48,48,96,0,0,0,0,0,124,0,0,0,0,0,0,0,0,24,24,0,0,0,
  6,12,24,48,96,0,0,0,60,102,102,102,60,0,0,0,12,60,108,12,12,0,0,0,
  60,70,28,48,124,0,0,0,60,6,28,6,60,0,0,0,12,60,108,124,12,0,0,0,
  126,96,60,6,124,0,0,0,60,96,124,102,60,0,0,0,124,12,24,48,96,0,0,0,
  60,102,60,102,60,0,0,0,60,102,62,6,60,0,0,0,0,0,24,0,24,0,0,0,
  0,24,0,24,48,0,0,0,6,24,96,24,6,0,0,0,0,124,0,124,0,0,0,0,
  96,24,6,24,96,0,0,0,56,76,24,24,0,24,0,0,56,124,124,96,56,0,0,0,
  60,102,126,102,102,0,0,0,124,102,124,102,124,0,0,0,60,102,96,102,60,0,0,0,
  120,102,102,102,120,0,0,0,126,96,124,96,126,0,0,0,126,96,124,96,96,0,0,0,
  60,102,96,110,54,0,0,0,102,102,126,102,102,0,0,0,60,24,24,24,60,0,0,0,
  28,12,12,108,56,0,0,0,102,108,112,108,102,0,0,0,48,48,48,48,62,0,0,0,
  102,126,126,102,102,0,0,0,102,118,110,110,102,0,0,0,60,102,102,102,60,0,0,0,
  124,102,124,96,96,0,0,0,60,102,102,110,62,0,0,0,124,102,124,108,102,0,0,0,
  60,112,12,6,56,0,0,0,126,24,24,24,24,0,0,0,102,102,102,102,126,0,0,0,
  102,102,102,60,24,0,0,0,102,102,126,126,102,0,0,0,102,102,24,102,102,0,0,0,
  102,102,24,24,24,0,0,0,126,12,24,48,126,0,0,0,30,24,24,24,30,0,0,0,
  32,48,24,12,4,0,0,0,120,24,24,24,120,0,0,0,16,56,108,0,0,0,0,0,
  0,0,0,0,0,254,0,0,192,96,0,0,0,0,0,0,0,62,102,102,62,0,0,0,
  96,124,102,102,124,0,0,0,0,60,96,96,60,0,0,0,6,62,102,102,62,0,0,0,
  0,56,124,96,56,0,0,0,24,120,96,96,96,0,0,0,0,62,102,62,6,62,0,0,
  96,124,102,102,102,0,0,0,24,0,24,24,24,0,0,0,24,0,24,24,24,112,0,0,
  96,108,112,108,102,0,0,0,56,24,24,24,60,0,0,0,0,104,84,84,84,0,0,0,
  0,120,102,102,102,0,0,0,0,56,108,108,56,0,0,0,0,120,108,108,120,96,0,0,
  0,60,108,108,60,12,0,0,0,108,112,96,96,0,0,0,0,60,112,12,120,0,0,0,
  24,60,24,24,12,0,0,0,0,102,102,102,62,0,0,0,0,102,102,36,24,0,0,0,
  0,84,84,84,40,0,0,0,0,102,24,102,102,0,0,0,0,102,102,126,6,60,0,0,
  0,124,24,48,124,0,0,0,14,24,56,24,14,0,0,0,24,24,0,24,24,0,0,0,
  112,24,28,24,112,0,0,0,50,76,0,0,0,0,0,0,24,60,102,126,0,0,0,0,
  56,108,96,108,56,96,0,0,102,0,102,102,62,0,0,0,12,56,124,96,56,0,0,0,
  60,0,62,102,62,0,0,0,102,0,62,102,62,0,0,0,48,0,62,102,62,0,0,0,
  12,0,62,102,62,0,0,0,0,60,96,96,60,96,0,0,60,0,56,124,96,56,0,0,
  108,0,56,124,96,56,0,0,48,0,56,124,96,56,0,0,54,0,24,24,24,0,0,0,
  60,0,24,24,24,0,0,0,48,0,24,24,24,0,0,0,66,24,102,126,102,0,0,0,
  24,24,102,126,102,0,0,0,8,126,96,124,96,126,0,0,126,27,127,216,126,0,0,0,
  63,120,216,222,248,223,0,0,56,0,56,108,56,0,0,0,108,0,56,108,56,0,0,0,
  48,0,56,108,56,0,0,0,60,0,102,102,62,0,0,0,48,0,102,102,62,0,0,0,
  102,0,102,126,6,60,0,0,130,56,108,108,56,0,0,0,102,0,102,102,126,0,0,0,
  24,60,96,96,60,24,0,0,24,120,96,96,126,0,0,0,102,102,24,126,24,0,0,0,
  122,71,90,66,65,0,0,0,28,60,48,48,96,0,0,0,6,0,62,102,62,0,0,0,
  12,0,24,24,24,0,0,0,12,0,56,108,56,0,0,0,6,0,102,102,62,0,0,0,
  124,0,124,102,102,0,0,0,126,0,102,126,110,102,0,0,62,102,102,62,0,126,0,0,
  56,108,108,56,0,126,0,0,24,0,24,50,28,0,0,0,0,62,48,48,48,0,0,0,
  0,124,12,12,12,0,0,0,66,68,74,17,38,79,0,0,66,68,72,18,38,66,0,0,
  24,0,24,24,24,0,0,0,18,36,72,36,18,0,0,0,72,36,18,36,72,0,0,0,
  170,0,170,0,170,0,0,0,170,170,170,170,170,170,0,0,170,85,170,85,170,85,0,0,
  24,24,24,24,24,24,0,0,24,24,24,24,248,24,0,0,24,24,24,248,24,248,0,0,
  102,102,102,102,230,102,0,0,0,0,0,0,254,102,0,0,0,0,0,248,24,248,0,0,
  102,102,102,230,6,230,0,0,102,102,102,102,102,102,0,0,0,0,0,254,6,230,0,0,
  102,102,102,230,6,254,0,0,102,102,102,102,254,0,0,0,24,24,24,248,24,248,0,0,
  0,0,0,0,248,24,0,0,24,24,24,24,31,0,0,0,24,24,24,24,255,0,0,0,
  0,0,0,0,255,24,0,0,24,24,24,24,31,24,0,0,0,0,0,0,255,0,0,0,
  24,24,24,24,255,24,0,0,24,24,24,31,24,31,0,0,102,102,102,102,103,102,0,0,
  102,102,102,103,96,127,0,0,0,0,0,127,96,103,0,0,102,102,102,231,0,255,0,0,
  0,0,0,255,0,231,0,0,102,102,102,103,96,103,0,0,0,0,0,255,0,255,0,0,
  102,102,102,231,0,231,0,0,24,24,24,255,0,255,0,0,102,102,102,102,255,0,0,0,
  0,0,0,255,0,255,0,0,0,0,0,0,255,102,0,0,102,102,102,102,127,0,0,0,
  24,24,24,31,24,31,0,0,0,0,0,31,24,31,0,0,0,0,0,0,127,102,0,0,
  102,102,102,102,255,102,0,0,24,24,24,255,24,255,0,0,24,24,24,24,248,0,0,0,
  0,0,0,0,31,24,0,0,255,255,255,255,255,255,0,0,0,0,0,255,255,255,0,0,
  240,240,240,240,240,240,0,0,15,15,15,15,15,15,0,0,255,255,255,0,0,0,0,0,
  0,54,108,108,54,0,0,0,48,120,112,120,112,96,0,0,126,96,96,96,96,0,0,0,
  0,254,108,108,108,0,0,0,126,48,24,48,126,0,0,0,14,56,108,108,56,0,0,0,
  0,102,102,102,122,224,0,0,0,0,126,24,12,0,0,0,60,24,60,24,60,0,0,0,
  60,102,126,102,60,0,0,0,60,102,102,36,102,0,0,0,30,56,108,108,56,0,0,0,
  0,102,219,102,0,0,0,0,2,60,124,108,120,128,0,0,60,96,124,96,60,0,0,0,
  60,102,102,102,102,0,0,0,124,0,124,0,124,0,0,0,24,126,24,0,126,0,0,0,
  96,24,6,24,96,126,0,0,6,24,96,24,6,126,0,0,14,27,24,24,24,24,0,0,
  24,24,216,216,112,0,0,0,24,0,126,0,24,0,0,0,102,152,0,102,152,0,0,0,
  24,60,24,0,0,0,0,0,0,24,60,24,0,0,0,0,0,24,24,0,0,0,0,0,
  7,196,40,16,0,0,0,0,48,40,40,0,0,0,0,0,56,12,48,60,0,0,0,0,
  0,60,60,60,0,0,0,0,254,0};
#endif

void cupos(x,y) int x,y; { cursorx=x; cursory=y; }

void pl(li,y) char huge *li; int y; {
  register char huge *v;
  register short *zp;
  register int h,count;
  register long ccc,hx;
  register int c;

  if(y>maxl) return;
  v=li; zp=(short *)&line[512];

  if(y==maxl) {
    count=0; do {
      if(((c=(int)*v++&255)<32)&&c) *zp++=c+0x8000+0x40*(c!=0);
      else *zp++=c;
      } while(++count < ll);
    }
  else if(shcont) {
    count=0; do {
      if((c=(int)*v++&255)<32) {
        switch(c) {
          case 0:        *zp++=0; count++; break;
          case 9:        do { *zp++=32; count++; } while(count&7); break;
          default:        *zp++=c+0x8000+0x40; count++; break;
          }
        }
      else { *zp++=c; count++; }
      } while(count < ll);
    }
  else {
    ccc=0l;
    h=count=0; do {
      if((c=(int)*v++&255)<32) {
        switch(c) {
          case 0:        *zp++=0; count++; break;
          case 2:        h ^= 0x4000; break;
          case 4:        h ^= 0x2000; break;
          case 9:        do { *zp++=32+h; count++; } while(count&7); break;
          case 17:        ccc ^= 1; break;
          case 19:        h ^= 0x8000; break;
          case 20:        if(h&0x100) h &= 0xfcff;
                        else { h &= 0xfcff; h |=256; }
                        break;
          case 22:        if(h&0x200) h &= 0xfcff;
                        else { h &= 0xfcff; h |=512; }
                        break;
          case 23:        h ^= 0x1000; break;
          default:        *zp++=c+0x8040; count++; break;
          }
        }
      else { *zp++=c+h; count++; if(ccc) { *zp++=h; count++; } }
      } while(count < ll);
    }

  zp=(short *)&line[512];
  if(linnr) if(y!=maxl) if(shlinnr==2) {
    hx=linnr-cy+y-1;
    zp[ll-6]=179; ccc=(hx/pageleng+1)%1000;
    if((int)ccc>99) {
      zp[ll-6]=(int)ccc/100+'0'+256; ccc %= 100;
      zp[ll-5]=(int)ccc/10+'0'+256; ccc %= 10;
      }
    else if((int)ccc>9) { zp[ll-5]=(int)ccc/10+'0'+256; ccc %= 10; }
    else zp[ll-5]=32;
    zp[ll-4]=(int)ccc+'0'+256;
    zp[ll-3]=124; h=(int)(hx%pageleng+1)%100;
    if(h==pageleng) {
      c=ll; do *zp++ |= 0x8000; while(--c);
      zp=(short *)&line[512];
      }
    if(h>9) { zp[ll-2]=h/10+'0'+256; h %= 10; }
    else zp[ll-2]=32;
    zp[ll-1]=h+'0'+256;
    }
  ply=y;
  plasm();
  }

void fill(adr,len,ch) char huge *adr; int len; char ch; {
  register char huge *h,c;
  register int l;
  h=adr; c=ch; l=len;
  do *h++ = c; while(--l != 0);
  }

void complinnr() {
  register char huge *cp,c;
  register unsigned long h;
  if(shlinnr==0) { linnr=0; return; }
  if(shlinnr==1) if(linnr==0) {
      linnr=1; h=plong(ga);
      for(cp=ta;plong(cp)<h;) if(*cp++==cr) linnr++;
      return;
      }
  if(shlinnr==2) if(linnr==0) {
      linnr=1; h=plong(ga);
      for(cp=ta;plong(cp)<h;) {
        c=*cp++;
        if(c==cr) linnr++;
/*        if(c==12) {
          linnr--; linnr-=linnr%pageleng-pageleng-1;
          } */
        }
      }
  }

char huge *putlin() {
  register char huge *cp,c;
  register int x;
  complinnr();
  fill(line,2*ll,0);
  cp=ga; while(*--cp != cr) ; cp++;
  x=0;
  while(c=*cp,cp++!=ga) if(x<ll) line[x++]=c;
  cp=ge;
  while((c=*cp++)!=cr) if(x<ll) line[x++]=c;
  pl(line,cy);
  return(cp);
  }

void restsc() {
  register char huge *cp,c;
  register int x,y;
  cp=putlin();
  y=cy+1;
  while((plong(cp)<plong(te))&&(y<maxl)) {
    fill(line,2*ll,0);
    x=0;
    while((c=*cp++)!=cr) if(x<ll) line[x++]=c;
    pl(line,y++);
    }
  if(y<maxl) {
    fill(line,2*ll,0);
    for(;y<maxl;y++) pl(line,y);
    }
  }

void putscr() {
  register char huge *cp,c;
  register int x,y;
  complinnr();
  y=cy; cp=ga;
  if(cp==ta) y=cy=0;
  else {
    while(*--cp != cr);
    if(y>0) while((plong(cp)>=plong(ta))&&(--y>=0)) while(*--cp != cr);
    cp++;
    if(y<0) y=0;
    if(cp==ta) { cy -= y; y=0; }
    }
  while(y != cy) {
    fill(line,2*ll,0);
    x=0;
    while((c=*cp++)!=cr) if(x<ll) line[x++]=c;
    pl(line,y++);
    }
  restsc();
  }

void error() {
  register char huge *h,huge *k;
  fill(line,2*ll,0);
#ifdef ENGLISH
  k="!!! ERROR !!!";
#endif
#ifdef GERMAN
  k="!!! FEHLER !!!";
#endif
  h=line;
  while((*h++=*k++)!=0); *--h=32;
  pl(line,maxl);
  if(key()==0) key(); escf=0;
  fill(line,2*ll,0);
  pl(line,maxl);
  }

void ende(cod) int cod; {
  endescreen();
  endekey();
  endeos();
  exit(cod);
  }

char *ext(s,e) char *s,*e; {
  int i,j;
  char *h,c;
  static char extstr[50];
  h=s; while(*h!=0) if(*h++=='\n') *--h=0;
  i=0; h=extstr; while((*h++=*s++)!=0) i++;
  if(i==0) return(extstr);
  for(j=i-1;j>=0;--j) {
    if((c=extstr[j])=='.') return(extstr);
    if((c=='\\')||(c==':')||(c=='/')) break;
    }
  h[-1]='.'; while((*h++=*e++)!=0);
  return(extstr);
  }

long infn(ff) FILE *ff; {
  long h;
  int i;
  h=0;
  while(1) {
    if((i=getc(ff))<=0) { fclose(ff); infende++; return(h); }
    if((i>='0')&&(i<='9')) { h*=10; h+=i-'0'; }
    else {
      while(i!='\n') if((i=getc(ff))<=0) { fclose(ff); infende++; return(h); }
      return(h);
      }
    }
  }

#ifdef GRAPHIC_FONT

int readfont(fn) char *fn; {
  int i,j,k;
  FILE *ff;
  if((ff=fopen(ext(fn,"FNT"),"r"))==0) {
#ifdef ENGLISH
    printf("cannot find font file %s\n",ext(fn,"FNT"));
#endif
#ifdef GERMAN
    printf("Ich kann den Zeichensatz %s nicht finden\n",ext(fn,"FNT"));
#endif
    return(1);
    }
#ifdef ENGLISH
  printf("reading font file\n");
#endif
#ifdef GERMAN
  printf("Ich lese den Zeichensatz\n");
#endif
  i=0;j=0;
  while((i<1024)&&((k=getc(ff))>0)) {
    switch(k){
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9': j = j*10+k-'0'; break;
      case ',': xfont[1024+i++]=j; j=0; break;
      default : break;
      }
    }
  fclose(ff); return(0);
  }

#endif

int readkeytab(fn) char *fn; {
  int i,j,k;
  FILE *ff;
  j=0;
  if((ff=fopen(ext(fn,"KEY"),"r"))==0) {
#ifdef ENGLISH
    printf("cannot find key table %s\n",ext(fn,"KEY"));
#endif
#ifdef GERMAN
    printf("Ich kann die Tastaturtabelle %s nicht finden\n",ext(fn,"KEY"));
#endif
    return(1);
    }
#ifdef ENGLISH
  printf("reading key table\n");
#endif
#ifdef GERMAN
  printf("Ich lade die Tastaturtabelle\n");
#endif
  while((k=getc(ff))>0) if(k!='\n') { if(++j&1) i=k; else kt1[k]=i; }
  fclose(ff); keytab=kt1; return(0);
  }

#ifdef LINUX

/* Berechnen der Bildschirmgroesse */

void termsize(int i) {
  int save_errno = errno;
  printf("\033[500;500H\033[6n"); fflush(stdout);
  signal(SIGWINCH,termsize);
  errno = save_errno;
  }

#endif

void prep() {
#ifdef GRAPHIC_FONT
  register int i;
  char *fnn;
#endif
  FILE *ff;
  initos();
  initscreen();
  initkey();
  cx=adcx=oldx=cy=escf=autoind=jflag=lm=putsfl=shcont=0;
  keytab=kt0;
  shlinnr=keepx=1;
  rm=60;
  pageleng=60;
  linnr=0;
  Unixsave=0;
  ta=text+4; *ta++=cr;
  te=text+tl-2; *te-- = cr; *te=cr;
  ga=ama=ta; ge=ame=te;
  *fndstr=*repstr=0;
#ifdef GRAPHIC_FONT
  for(i=0;i<4096;i++) xfont[i]=yfont[i];
  for(i=2048;i<4096;i+=8) {
    xfont[i+2048]=xfont[i+2049]=0;
    xfont[i+2050]=xfont[i];
    xfont[i+2051]=xfont[i+1];
    xfont[i+2052]=xfont[i+2];
    xfont[i+2053]=xfont[i+3];
    xfont[i+2054]=xfont[i+4];
    xfont[i+2055]=xfont[i+5];
    }
#endif
  infende=((ff=fopen("edi.inf","r"))==0);
  if(infende) goto brlab;
  autoind=(int)infn(ff);
  if(infende) goto brlab;
  rm=(int)infn(ff);
  if(infende) goto brlab;
  lm=(int)infn(ff);
  if(infende) goto brlab;
  jflag=(int)infn(ff);
  if(infende) goto brlab;
  shcont=(int)infn(ff);
  if(infende) goto brlab;
  shlinnr=(int)infn(ff);
  if(infende) goto brlab;
  pageleng=infn(ff);
#ifdef GRAPHIC_FONT
  if(gargc<3) {
    if((fnn=fgets(fndstr,ll,ff))!=0) if(readfont(fnn)) ende(1);
    if((fnn=fgets(fndstr,ll,ff))!=0) if(readkeytab(fnn)) ende(1);
    }
#endif
  brlab: if(infende==0) fclose(ff);
  }

void compcx() {
  register char huge *cp,c;
  register int i,f;
  cp=ga; while(*--cp != cr) ; cp++;
  f=cx=adcx=0;
  while(c=*cp,plong(cp)!=plong(ga)) {
    cp++;
    if(c==9) { i=cx; cx = ((cx+8)& -8); adcx=((i+adcx+8)& -8)-cx; }
    else if((unsigned)c>31) { cx++; adcx+=f; }
    else {
      if(shcont) adcx++;
      else {
              switch(c) {
                default:        adcx++; break;
                case 17:        f ^= 1;
                case 2:
                case 4:
                case 20:
                case 22:
                case 23:
                case 19:        break;
                }
              }
      }
    }
  }

void incl(c) char c; {
  if(plong(ga)<(plong(ge)-4)) {
    *ga++ = c;
    if((c!=cr)&&((cx)>=rm)&&jflag) {
      register char huge *g,huge *h,huge *hh;
      register int i,count,crfl;
      g=ga; h=ge;
      while((c=*--g)!=32) {
              if(c==cr) { g++; while(g!=ga) *g++=*h++; return; }
              *--h=c;
              }
      *--h=cr; if(linnr) linnr++; if(++cy>maxl-1) cy=(maxl>>1)-1;
      *g=cr; count=0;
      while((*--h=*--g)!=cr); *g++=*h++; hh=g;
      while((c=*hh++)!=cr) {
        if(c==9) count = ((count+8)& -8);
        else if((unsigned)c>31) count++;
        }
      crfl=0;
      for(i=0;i<lm;i++) if((*g++=*h++)==cr) { *--h=*--g; break; }
      while(*h++==32); --h;
      while((i=*g++=*h++)!=cr) if(i==32) crfl++; *--h=*--g;
      if(crfl==0) count=rm;
      crfl=-1;
      while(1) {
        if(count>=rm) break;
        if(plong(g)>=(plong(h)-4)) break;
        if((i=*h++)==cr) {
          --h;
          while((*--h=*--g)!=cr); *g++=*h++;
          for(i=0;i<lm;i++) if((*g++=*h++)==cr) { *--h=*--g; break; }
          while(*h++==32); --h;
          crfl++;
          continue;
          }
        if(i==32) {
          if(crfl||(g[-1]==46)||(g[-1]==44)) { *g++=i; count++; }
          while((*g++=*h++)==32); *--h=*--g;
          }
        *g++=i;
        }
      while((*g++=*h++)!=cr);
      i=lm; while(i--) { if(plong(g)>=(plong(h)-4)) break; *g++=32; }
      while(h!=ge) *g++=*h++;
      ga=g;
      if(putsfl==0) putscr();
      return;
      }
    }
  }

void delete() {
  if(plong(ga)>plong(ta)) {
    if(*--ga == cr) {
      if(linnr) --linnr;
      if(cy--==0) { cy=(maxl>>1)-1; putscr(); }
      else restsc();
      }
    else putlin();
    }
  }

void dellin() {
  while(*--ga != cr); ga++;
  while(*ge++ != cr); if(plong(ge)>plong(te)) --ge;
  restsc();
  }

void left() {
  if(plong(ga)>plong(ta)) if((*--ge=*--ga)==cr) {
    if(linnr) --linnr;
    if(--cy<0) { cy=(maxl>>1)-1; putscr(); }
    }
  }

void right() {
  if(plong(ge)<plong(te)) if((*ga++=*ge++)==cr) {
    if(linnr) linnr++;
    if(++cy>maxl-1) { cy=(maxl>>1)-1; putscr(); }
    }
  }

void up() {
  int xm,h;
  if(plong(ga)>plong(ta)) {
    xm=oldx; h=0;
    if(keepx) { while((*--ge=*--ga)!=cr); ge++; ga++; }
    left();
    while((*--ge=*--ga)!=cr);
    ge++; ga++;
    if(keepx&&xm) while(h<xm) {
      if(*ge==cr) break;
      if(*ge==9) h=((h+8) & 0xfff8)-1;
      right(); h++;
      }
    }
  }

void down() {
  int xm,h;
  if(plong(ge)<plong(te)) {
    xm=oldx; h=0;
    while((*ga++=*ge++)!=cr);
    --ga; --ge;
    right();
    if(keepx&&xm) while(h<xm) {
      if(*ge==cr) break;
      if(*ge==9) h=((h+8) & 0xfff8)-1;
      right(); h++;
      }
    }
  }

void startofline() {
  if(plong(ga)>plong(ta)) {
    while((*--ge=*--ga)!=cr);
    ge++; ga++;
    }
  }
 
void endofline() {
  if(plong(ge)<plong(te)) {
    while((*ga++=*ge++)!=cr);
    --ga; --ge;
    }
  }

void wleft() {
  register char c;
  left();
  if(plong(ga)>plong(ta)) {
    do left(); while((c=*ge),((c==32||c==9))&&(plong(ga)>plong(ta)));
    do left(); 
while((c=*ge),c!=cr&&c!=32&&c!=9&&c!=','&&(plong(ga)>plong(ta)));
    if(plong(ga)!=plong(ta)) right();
    }
  }

void wright() {
  register char c;
  if(plong(ge)<plong(te)) {
    do right(); while((c=*ge),c!=cr&&c!=32&&c!=9&&c!=',');
    do right(); while((c=*ge),c==32||c==9);
    if(*ge==cr) right();
    }
  }

void pgup() {
  register int i;
  for(i=(maxl<<1)/3;i!=0;--i) up();
  }

void pgdown() {
  register int i;
  for(i=(maxl<<1)/3;i!=0;--i) down();
  }

void bottom() {
  register long h;
  register char huge *gga,huge *gge;
  gga=ga; gge=ge;
  if((h=plong(te)-plong(gge))>0) {
    cy=maxl-2;
    do *gga++=*gge++; while(--h);
    ga=gga; ge=gge;
    linnr=0;
    putscr();
    }
  }

void top() {
  register long h;
  register char huge *gga,huge *gge;
  gga=ga; gge=ge;
  if((h=plong(gga)-plong(ta))>0) {
    cy=0;
    do *--gge=*--gga; while(--h != 0);
    ga=gga; ge=gge;
    linnr=1;
    putscr();
    }
  }

void area() { ama=ga; ame=ge; }

void getlin(p,s,ec) char *p,*s,ec; {
  register char *h,*k,c;
  fill(line,2*ll,0);
  h=line; while((c=*p++)!=0) *h++=c;
  k=h;
  while(pl(line,maxl),cupos((int)(plong(h)-plong(line)),maxl),
        invcur(),c=keytab[key()],invcur(),(c!=ec)||escf) {
    if((c==0)&&(ec==127)) { if((c=key())==83) break; else *h++=0; }
    if(c!=8) *h++=c;
    else if(escf) *h++=c;
    else if(h!=k) *--h=32;
    pl(line,maxl);
    escf=0;
    }
  *h=0;
  while((*s++=*k++)!=0);
  }

int readx(fn) char *fn; {
  register char c,*h;
  FILE *ff;
  register int i,j;
  char crjt;
  crjt=0;
  if((ff=fopen(fn,READACCESS))==0) return(1);
  while(1) {
    j=(int)fread(line,1,BUFLEN,ff);
    h=line; i=j; if(i) do {
      c=*h++;
      if(plong(ga)>(plong(ge)-3)) { fclose(ff); return(1); }
      if(c==RS1) { *ga++=cr; crjt=1; continue; }
#ifdef RS2
      if(c==RS2) { if(crjt) { crjt=0; continue; } c=cr; }
#endif
      *ga++=c; crjt=0;
      } while(--i);
    if(j<BUFLEN) { fclose(ff); return(0); }
    }
  }

void load() {
  char fn[60];
#ifdef ENGLISH
  getlin("input file name :",fn,cr);
#endif
#ifdef GERMAN
  getlin("einzufuegende Datei :",fn,cr);
#endif
  cy=20;
  if(readx(fn)) error();
  linnr=0;
  putscr();
  }

int writex(fn) char *fn; {
  register char huge *k,huge *h;
  FILE *ff;
  register size_t i;
  int resul;
  if((ff=fopen(fn,WRITEACCESS))==0) return(1);
  k=sma;
  while(1) {
    h=line; i=0; do {
      if(k==sme) {
              resul=(fwrite(line,1,i,ff)!=i);
        fclose(ff); return resul;
              }
      if(*k==cr) {
        if(Unixsave) { *h++=10; k++; }
        else {
          *h++=RS1; k++;
#ifdef RS2
          *h++=RS2; i++;
#endif
          }
        }
      else *h++=*k++;
      } while(i++ < BUFLEN);
    if(fwrite(line,1,i,ff)!=i) {
      fclose(ff); return(1);
      }
    }
  }

void save() {
  char fn[60];
  register char huge *g,huge *h;
  char *gn;
  register long l,lins;
  register int ys;
  lins=linnr; ys=cy;
  l=plong(te)-plong(ge);
#ifdef ENGLISH
  getlin("output file name :",fn,cr);
#endif
#ifdef GERMAN
  getlin("Ausgabedateiname :",fn,cr);
#endif
  gn=fn; if(*gn==0) gn=mfile;
  bottom(); sma=ta; sme=ga;
  if(writex(gn)) error();
  if(l) {
    g=ga; h=ge;
    do *--h=*--g; while(--l);
    ga=g; ge=h;
    linnr=lins; cy=ys; putscr();
    }
  }

void saveex() {
  char fn[60];
  register char *fii;
  bottom(); sma=ta; sme=ga; fii=mfile;
#ifdef ENGLISH
  if(*mfile==0) { getlin("output file name :",fn,cr); fii=fn; }
#endif
#ifdef GERMAN
  if(*mfile==0) { getlin("Ausgabedateiname :",fn,cr); fii=fn; }
#endif
  if(writex(fii)) error();
  else { cls(); ende(0); }
  }

void writea() {
  char fn[60];
  if(plong(ama)<plong(ga) && plong(ame)<plong(ga) ||
     plong(ama)>plong(ge) && plong(ame)>plong(ge)) return;
  if(plong(ama) != plong(ga)) {
#ifdef ENGLISH
    getlin("output file name :",fn,cr);
#endif
#ifdef GERMAN
    getlin("Ausgabedateiname :",fn,cr);
#endif
    if(plong(ga)<plong(ama)) { sma=ge; sme=ame; }
    else { sma=ama; sme=ga; }
    if(writex(fn)) error();
    }
  }

void clra() {
  if(plong(ama)<plong(ga) && plong(ame)<plong(ga) ||
     plong(ama)>plong(ge) && plong(ame)>plong(ge)) return;
  if(plong(ama) != plong(ga)) {
    if(plong(ga)<plong(ama)) ge=ame;
    else ga=ama;
    cy=(maxl>>1)-1; linnr=0; putscr();
    }
  }

void fndnxt() {
  register char huge *h,huge *g,c,d;
  h=fndstr; if((c=*h)==0) return;
  if(ge==te) return;
  *ga++=*ge++;
  linnr=0;
  while(plong(ge)<plong(te)) {
    if((*ga++=*ge++)==c) {
      h=fndstr; h++; g=ge;
      while(1) {
        if((d=*h++)==0) { --ga; --ge; return; }
        if(*g++!=d) break;
        if(g==te) break;
        }
      }
    }
  }

void next() { fndnxt(); cy=(maxl>>1)-1; putscr(); }

int repl() {
  register char huge *h,huge *g,c;
  if(ge==te) return(0);
  h=fndstr; g=ge;
  if(*h==0) return(0);
  while((c=*h++)!=0) if((*g++ != c)||(plong(g)>plong(te))) return(0);
  linnr=0;
  ge=g;
  h=repstr;
  while((c=*h++)!=0) {
    if(plong(ga)>plong(ge)-3) return(1);
    *ga++=c;
    }
  *--ge=*--ga;
  fndnxt();
  return(1);
  }

void replace() { repl(); cy=(maxl>>1)-1; putscr(); }

void find() {
#ifdef ENGLISH
  getlin("search for :",fndstr,127);
  getlin("replace by :",repstr,127);
#endif
#ifdef GERMAN
  getlin("suchen nach :",fndstr,127);
  getlin("ersetzen durch :",repstr,127);
#endif
  next();
  }

void repall() {
  if(repl()) {
    while(repl());
    cy=(maxl-2);
    if(ge!=te) bottom(); else putscr();
    }
  }

void format() {
  register char c1,c2;
  register int i;
  if(jflag==0) return;
  if(plong(ge)>plong(te)-3) return;
  linnr=0;
  if((*ge==cr)&&(ga[-1]==cr)) { *ga++=*ge++; return; }
  while((*--ge=*--ga)!=cr); ge++; ga++;
  for(i=0;i<=lm;i++) {
    if(ge==te) return;
    if((*ga++=*ge++)==cr) {
      if(ge==te) return;
      if(*ge==cr) { *ga++=*ge++; return; }
      ga--; i--;
      }
    }
  if(ga[-1]==cr) { while(*ge++==32); --ge; }
  if(plong(ge)>plong(te)-3) return;
  c2=*ge++;
  while(1) {
    c1=c2; c2=*ge++;
    if((ge==te)||((c1==cr)&&(c2==cr))) {
      putsfl=1;
      incl(c1); if(c1==cr) if(++cy>maxl-1) cy=(maxl>>1)-1;
      incl(c2); if(c2==cr) if(++cy>maxl-1) cy=(maxl>>1)-1;
      putsfl=0; return;
      }
    if(c1==cr) c1=32;
    if((c1==32)&&(c2==32)) continue;
    compcx(); putsfl=1; incl(c1); putsfl=0;
    }
  }

long getdec(px) char *px; {
  register char *h,*k,*p,c;
  register long wert;
  wert=0; p=px;
  fill(line,2*ll,0);
  h=line; while((c=*p++)!=0) *h++=c;
  k=h;
  while(pl(line,maxl),cupos((int)(plong(h)-plong(line)),maxl),
        invcur(),c=key(),invcur(),c!=cr) {
    switch(c) {
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9': *h++=c; wert = wert*10+c-'0'; break;
      case 8: if(h!=k) { *--h=32; wert /= 10; }
      default: break;
      }
    pl(line,maxl);
    escf=0;
    }
  if(wert==0) return(getdec(px));
  return(wert);
  }

void getpgl() {
#ifdef ENGLISH
  pageleng=getdec("lines per page: ");
#endif
#ifdef GERMAN
  pageleng=getdec("Zeilen pro Seite: ");
#endif
  }

void ph(nr,s) int nr; char *s; {
  int ssh,ssl;
  ssh=shcont; ssl=shlinnr; shcont=shlinnr=0;
  fill(line,2*ll,0);
  sprintf(line,s);
  pl(line,nr);
  shcont=ssh; shlinnr=ssl;
  }

void contq() {
  int c;
  cls();
#ifdef ENGLISH
  ph(maxl>>1,"                        abandon text [y/n] ? ");
#endif
#ifdef GERMAN
  ph(maxl>>1,"                        Text verwerfen [j/n] ? ");
#endif
  do {
    c=key()|32;
    if((c=='j')||(c=='y')) { cls(); ende(0); }
    } while(c!='n');
  putscr();
  }

void inscr() {
  register char huge *g,c;
  if(autoind) {
    g=ga; *g++=0;
    while(*--g!=cr); g++;
    incl(cr);
    while(((c=*g++)==32)||(c==9)) incl(c);
    }
  else incl(cr);
  if(linnr) linnr++;
  if(++cy > maxl-1) { cy=(maxl>>1)-1; putscr(); }
  else if(autoind) putscr();
  else {
    --cy; *--ge=cr; --ga;
    if(linnr) { --linnr;  putlin(); linnr++; }
    else putlin();
    cy++; ge++; ga++; restsc();
    }
  escf=0;
  }

void hs3(x) int x; {
#ifdef ENGLISH
 ph(26-x,"control characters");
 ph(28-x,"press Esc, then enter control character");
 ph(30-x,"Control/B - bold	Control/D - double strike");
 ph(31-x,"Control/S - underline	Control/Q - large");
 ph(32-x,"Control/W - italic");
 ph(33-x,"Control/T - power	Control/V - index");
#endif
#ifdef GERMAN
 ph(27-x,"Steuerzeichen");
 ph(29-x,"druecke Esc, danach das Steuerzeichen");
 ph(30-x,"Control/B - fett          	Control/D - Doppeldruck");
 ph(31-x,"Control/S - unterstreichen 	Control/Q - doppelt breit");
 ph(32-x,"Control/W - kursiv");
 ph(33-x,"Control/T - hochgestellt  	Control/V - tiefgestellt");
#endif
 }

void key0() {
  switch (key()) {
    default: break;
    case 59: help(); break;
    case 60: format(); putscr(); ox++; break;
    case 61: shcont = !shcont; putscr(); break;
    case 62: if(++shlinnr==3) shlinnr=0; putscr(); break;
    case 63: getpgl(); putscr(); break;
    case 64: if(cx<rm) lm=cx; break;
    case 65: if(cx>lm) rm=cx; break;
    case 66: jflag ^= 1; break;
    case 67: autoind ^= 1; break;
    case 133: invers ^= 255; cls(); putscr(); break;
    case 134: if(bh==16) { bh=8; cy<<=1; } else { bh=16; cy>>=1; }
              initscreen(); putscr(); break;
    case 71: startofline();break;
    case 79: endofline(); break;
    case 75: left(); ox++; break;
    case 77: right(); ox++; break;
    case 72: up(); break;
    case 80: down(); break;
    case 83: if(plong(ge) != plong(te)) { right(); delete(); ox++; } break;
    case 73: startofline(); break;
    case 81: endofline(); break;
    case 115: wleft(); ox++; break;
    case 116: wright(); ox++; break;
/*    case  82: */
    case 117: if(cy) { cy=0; putscr(); } break;
    case 255:  cy=(maxl>>1)-1; putscr(); break;
    }
  }

int main(argc,argv) int argc; char *argv[]; {
  register int c;
  gargc=argc;
  for(c=0;c<256;c++) kt0[c]=kt1[c]=c;
  prep();
#ifdef GRAPHIC_FONT
  if(argc>2) if(readfont(argv[2])) exit(1);
  if(argc>3) if(readkeytab(argv[3])) exit(1);
#else
  if(argc>2) if(readkeytab(argv[2])) exit(1);
#endif
  cls();
  mfile="";
  if(argc>1) {
    mfile=argv[1];
    if(readx(mfile)) error();
    top();
    }
  else {
    ph(8,open_s1);
    ph(10,"(c) 1991-2000 Andreas Graf");
#ifdef ENGLISH
    ph(12,"release: 19-dec-2000");
#endif
#ifdef GERMAN
    ph(12,"Auslieferung: 19-Dez-2000");
#endif
    fill(line,2*ll,0);
#ifdef ENGLISH
    sprintf(line,"free: %ld characters",plong(ge)-plong(ga));
#endif
#ifdef GERMAN
    sprintf(line,"frei: %ld Anschlaege",plong(ge)-plong(ga));
#endif
    pl(line,14);
#ifdef OS9
#ifdef ENGLISH
    ph(16,"press PF1 for help");
#endif
#ifdef GERMAN
    ph(16,"druecke Hilfe fuer Hilfe");
#endif
#else
#ifdef ENGLISH
    ph(16,"press F1 for help");
#endif
#ifdef GERMAN
    ph(16,"druecke F1 fuer Hilfe");
#endif
#endif
    cupos(0,0);
#ifdef LINUX
    while(kbhit()==0) usleep(200);
#else
    while(kbhit()==0);
#endif
    cls();
    }
#ifdef LINUX
  termsize(0);
#endif
  while(1) {
    cupos(cx+adcx,cy);
#ifndef NOKBHIT
    if(kbhit()==0) {
#endif
      fill(line,2*ll,0);
#ifdef ENGLISH
      sprintf(line,
        "col: %5d  line: %6ld    used: %6ld  free: %6ld  (c) A.Graf",
        cx,linnr,
        plong(te)-plong(ta)-plong(ge)+plong(ga),plong(ge)-plong(ga));
      if(autoind) line[74]='I'; if(jflag) line[76]='J';
#endif
#ifdef GERMAN
      sprintf(line,
        "Spalte: %5d Zeile: %6ld   benutzt: %6ld frei: %6ld  (c) A.Graf",
        cx,linnr,
        plong(te)-plong(ta)-plong(ge)+plong(ga),plong(ge)-plong(ga));
      if(autoind) line[74]='E'; if(jflag) line[76]='U';
#endif
      if(shlinnr==0) for(c=13;c<28;c++) line[c]=32;
      pl(line,maxl);
      cupos(cx+adcx,cy);
#ifndef NOKBHIT
      }
#endif
    invcur();
#ifdef LINUX
    while(kbhit()==0) usleep(200);
#endif
    c=keytab[key()];
    invcur();
    ox=0;
    if(c==cr) { inscr(); ox++; }
    else if((c==127)&&(escf==0)) { if(plong(ge) != plong(te)) { right(); 
delete(); ox++; } }
    else if((c==0)&&escf) { incl((char)0); incl((char)(key())); putlin(); 
escf=0; ox++; }
    else if((c>31)||escf) { incl((char)c); putlin(); escf=0; ox++; }
    else switch(c) {
      default: incl((char)c); putlin(); escf=0; ox++; break;
      case  0: key0(); break;
      case  1: area(); break;
      case  2: bottom(); ox++; break;
      case  3: pgdown(); break;
      case  5: Unixsave=1; saveex(); Unixsave=0; break;
      case  6: find(); ox++; break;
      case  7: clra(); ox++; break;
      case  8: delete(); ox++; break;
      case  9: incl((char)c); putlin(); ox++; break;
      case 11: keepx ^= 1; break;
      case 12: load(); ox++; break;
      case 14: next(); ox++; break;
      case 15: replace(); ox++; break;
      case 24:
      case 17: contq(); break;
      case 18: pgup(); break;
      case  4:
      case 19: save(); break;
      case 20: top(); ox++; break;
      case 21: repall(); ox++; break;
      case 22: if(keytab==kt0) keytab=kt1; else keytab=kt0; break;
      case 23: writea(); break;
      case 25: dellin(); ox++; break;
      case 26: saveex(); break;
      case 27: escf=1; break;
      }
    compcx(); if(ox) oldx=cx;
    }
  return 0;
  }
