/* EDI_KEY.C */

/* 19-dec-2000 */

/* Author: A.Graf */

#include "edi.h"

extern unsigned char *keytab,kt0[],kt1[];
extern int escf,maxl;
extern char *open_s2;

int exkey;

/********************************************************************/
/*                                                                  */
/*                     tastaturabhaengige Funktionen                */
/*                                                                  */
/********************************************************************/

#ifdef ST

char mouseinit[]={10,5,5};
char mousereset[]={8};
int acf;

int ac(i) int i; {
  unsigned char *s,c,ic;
  ic=(unsigned char)i;
  switch(acf) {
    case 1:	s=(unsigned char *)" 'eEaiou"; break;
    case 2:	s=(unsigned char *)" `aeiou";   break;
    case 3:	s=(unsigned char *)" ^aeiou";   break;
    case 4:	s=(unsigned char *)" ~uaeiAoyOUnN~"; break;
    default:	acf=0; return(i);
    }
  acf=0; c=s[1];
  while(*s) { if(*s++==ic) return((int)*s); else s++; }
  exkey=i; return(c);
  }

int key() {
  register long h;
  register int i,j,c;
  if((i=exkey)!=0) { exkey=0; return(i); }
  h=Crawcin();
  i=(int)h&255;
  if(keytab==kt0) {
    if(acf) return(ac(i));
    if(i==39)  { acf=1; return(key()); }
    if(i=='`') { acf=2; return(key()); }
    if(i=='^') { acf=3; return(key()); }
    if(i=='~') { acf=4; return(key()); }
    }
  if(i==127) { exkey=83; return(0); }
  if(i) return(i==158 ? 225 : i);
  exkey=(int)(h>>16);
  if(exkey==82) exkey=79;
  if(exkey==97) exkey=73;
  if(exkey==98) exkey=81;
  if(exkey==68) {
    escf=1; i=0;
    while(((j=(int)Crawcin())>='0')&&(j<='9')) {
      c=j-'0';
      if(i+c>255) break;
      i*=10; i+=c;
      if(i>25) { exkey=0; return(i&255); }
      }
    exkey=j;
    return(i&255);
    }
  return(0);
  }

void initkey() { Ikbdws(2,mouseinit); acf=0; }

void endekey() { Ikbdws(0,mousereset); }

void help() {
  cls();
  ph(0,open_s2);
#ifdef ENGLISH
  ph(2,"Control/T,Home - top of text	Control/B - bottom of text");
  ph(3,"Control/C - page down		Control/R - page up");
  ph(4,"Control/Y - delete line		Control/V - switch keyboard");

  ph(6,"Control/L - load file		Control/S - save file");

  ph(8,"Control/A - mark area (cursor position is other end)");
  ph(9,"Control/W - write marked area   Control/G - delete marked area");
 ph(12,"use Control/A, Control/W and Control/L to copy or move blocks");

 ph(13,"Control/F - find string		Control/N - find next");
 ph(14,"Control/O - replace and find next");
 ph(15,"Control/U - replace all from cursor to end of text");

 ph(17,"F10 - insert decimal code	Esc - insert control character");

 ph(19,"Control/Q - quit		Control/Z - save & exit");
 ph(20,"Control/E - save & exit in UNIX style");
#endif
#ifdef GERMAN
  ph(2,"Control/T,Home - Textanfang	Control/B - Textende");
  ph(3,"Control/C - Seite runter	Control/R - Seite hoch");
  ph(4,"Control/Y - Zeile loeschen	Control/V - Tastatur umschalten");

  ph(6,"Control/L - Datei laden		Control/S - Datei abspeichern/sichern");

  ph(8,"Control/A - Gebiet markieren (Cursorposition ist das andere Ende");
  ph(9,"Control/W - Gebiet schreiben	Control/G - Gebiet loeschen");
 ph(12,"nimm Control/A, Control/W und Control/L um Bloecke zu kopieren");

 ph(13,"Control/F - finde Zeile		Control/N - finde naechstes Auftreten");
 ph(14,"Control/O - austauschen und naechstes Auftreten finden");
 ph(15,"Control/U - alle Suchzeilen austauschen vom Cursor bis zum 
Textende");

 ph(17,"F10 - Dezimalcode einfuegen	Esc - Steuerzeichen einfuegen");

 ph(18,"Control/Q - Editor verlassen, Text verwerfen");
 ph(19,"Control/Z - Editor verlassen, Text abspeichern");
 ph(20,"Control/E - Editor verlassen, Text im UNIX-Stil abspeichern");
#endif
  if(maxl>33) { hs2(0); hs3(0); }
  else {
#ifdef ENGLISH
 ph(maxl,"press F1 for next help screen");
#endif
#ifdef GERMAN
 ph(maxl,"Druecke F1 fuer naechsten Hilfe-Schirm");
#endif
    if(key()==0) if(key()==59) { cls(); hs2(21); hs3(21); }
    }
  if(key()==0) key();
  escf=0;
  putscr();
  }

void hs2(x) int x; {
#ifdef ENGLISH
 ph(21-x,"F8 - toggle justification	F9 - toggle autoindent");
 ph(22-x,"F6 - set left margin		F7 - set right margin");
 ph(23-x,"F2 - format paragraph		F3 - show control characters");
 ph(24-x,"F4 - show page/line number	F5 - enter page size");
#endif
#ifdef GERMAN
 ph(22-x,"F8 - Autoumbruch umschalten	F9 - automatisches Einruecken 
umschalten");
 ph(23-x,"F6 - linken Rand setzen		F7 - rechten Rand setzen");
 ph(24-x,"F2 - Absatz formatieren		F3 - Controlzeichen zeigen");
 ph(25-x,"F4 - Seiten-/Zeilennr. zeigen	F5 - Seitengroesse eingeben");
#endif
 }

#endif

#ifdef GEMDOSKEY

int acf;

int ac(i) int i; {
  unsigned char *s,c,ic;
  ic=(unsigned char)i;
  switch(acf) {
    case 1:	s=(unsigned char *)" 'eEaiou"; break;
    case 2:	s=(unsigned char *)" `aeiou";   break;
    case 3:	s=(unsigned char *)" ^aeiou";   break;
    case 4:	s=(unsigned char *)" ~uaeiAoyOUnN~"; break;
    default:	acf=0; return(i);
    }
  acf=0; c=s[1];
  while(*s) { if(*s++==ic) return((int)*s); else s++; }
  exkey=i; return(c);
  }

int key() {
  register long h;
  register int i,j,c;
  if((i=exkey)!=0) { exkey=0; return(i); }
  h=Crawcin();
  i=(int)h&255;
  if(keytab==kt0) {
    if(acf) return(ac(i));
    if(i==39)  { acf=1; return(key()); }
    if(i=='`') { acf=2; return(key()); }
    if(i=='^') { acf=3; return(key()); }
    if(i=='~') { acf=4; return(key()); }
    }
  if(i==127) { exkey=83; return(0); }
  if(i) return(i==158 ? 225 : i);
  exkey=(int)(h>>16);
  if(exkey==82) exkey=79;
  if(exkey==97) exkey=73;
  if(exkey==98) exkey=81;
  if(exkey==68) {
    escf=1; i=0;
    while(((j=(int)Crawcin())>='0')&&(j<='9')) {
      c=j-'0';
      if(i+c>255) break;
      i*=10; i+=c;
      if(i>25) { exkey=0; return(i&255); }
      }
    exkey=j;
    return(i&255);
    }
  return(0);
  }

void initkey() { acf=0; }

void endekey() { }

void help() {
  cls();
  ph(0,open_s2);
#ifdef ENGLISH
  ph(2,"Control/T,Home - top of text	Control/B - bottom of text");
  ph(3,"Control/C - page down		Control/R - page up");
  ph(4,"Control/Y - delete line		Control/V - switch keyboard");

  ph(6,"Control/L - load file		Control/S - save file");

  ph(8,"Control/A - mark area (cursor position is other end)");
  ph(9,"Control/W - write marked area   Control/G - delete marked area");
 ph(12,"use Control/A, Control/W and Control/L to copy or move blocks");

 ph(13,"Control/F - find string		Control/N - find next");
 ph(14,"Control/O - replace and find next");
 ph(15,"Control/U - replace all from cursor to end of text");

 ph(17,"F10 - insert decimal code	Esc - insert control character");

 ph(19,"Control/Q - quit		Control/Z - save & exit");
 ph(20,"Control/E - save & exit in UNIX style");
#endif
#ifdef GERMAN
  ph(2,"Control/T,Home - Textanfang	Control/B - Textende");
  ph(3,"Control/C - Seite runter	Control/R - Seite hoch");
  ph(4,"Control/Y - Zeile loeschen	Control/V - Tastatur umschalten");

  ph(6,"Control/L - Datei laden		Control/S - Datei abspeichern/sichern");

  ph(8,"Control/A - Gebiet markieren (Cursorposition ist das andere Ende");
  ph(9,"Control/W - Gebiet schreiben	Control/G - Gebiet loeschen");
 ph(12,"nimm Control/A, Control/W und Control/L um Bloecke zu kopieren");

 ph(13,"Control/F - finde Zeile		Control/N - finde naechstes Auftreten");
 ph(14,"Control/O - austauschen und naechstes Auftreten finden");
 ph(15,"Control/U - alle Suchzeilen austauschen vom Cursor bis zum 
Textende");

 ph(17,"F10 - Dezimalcode einfuegen	Esc - Steuerzeichen einfuegen");

 ph(18,"Control/Q - Editor verlassen, Text verwerfen");
 ph(19,"Control/Z - Editor verlassen, Text abspeichern");
 ph(20,"Control/E - Editor verlassen, Text im UNIX-Stil abspeichern");
#endif
  if(maxl>33) { hs2(0); hs3(0); }
  else {
#ifdef ENGLISH
 ph(maxl,"press F1 for next help screen");
#endif
#ifdef GERMAN
 ph(maxl,"Druecke F1 fuer naechsten Hilfe-Schirm");
#endif
    if(key()==0) if(key()==59) { cls(); hs2(21); hs3(21); }
    }
  if(key()==0) key();
  escf=0;
  putscr();
  }

void hs2(x) int x; {
#ifdef ENGLISH
 ph(21-x,"F8 - toggle justification	F9 - toggle autoindent");
 ph(22-x,"F6 - set left margin		F7 - set right margin");
 ph(23-x,"F2 - format paragraph		F3 - show control characters");
 ph(24-x,"F4 - show page/line number	F5 - enter page size");
#endif
#ifdef GERMAN
 ph(22-x,"F8 - Autoumbruch umschalten	F9 - automatisches Einruecken 
umschalten");
 ph(23-x,"F6 - linken Rand setzen		F7 - rechten Rand setzen");
 ph(24-x,"F2 - Absatz formatieren		F3 - Controlzeichen zeigen");
 ph(25-x,"F4 - Seiten-/Zeilennr. zeigen	F5 - Seitengroesse eingeben");
#endif
 }

#endif

#ifdef MS_DOS

int kbhit() { return((bios(33,11,0,0,0,0)&255)!=0); }

int key() {
  static union REGS inregs,outregs;
  inregs.h.ah=7;
  int86(33,&inregs,&outregs);
  return(outregs.x.ax&255);
  }

void initkey() {}

void endekey() {}

void help() {
  cls();
  ph(0,open_s2);
#ifdef ENGLISH
  ph(2,"Control/T,Home - top of text	Control/B - bottom of text");
  ph(3,"Control/C - page down		Control/R - page up");
  ph(4,"Control/Y - delete line		Control/V - switch keyboard");

  ph(6,"Control/L - load file		Control/S - save file");

  ph(8,"Control/A - mark area (cursor position is other end)");
  ph(9,"Control/W - write marked area   Control/G - delete marked area");
 ph(12,"use Control/A, Control/W and Control/L to copy or move blocks");

 ph(13,"Control/F - find string		Control/N - find next");
 ph(14,"Control/O - replace and find next");
 ph(15,"Control/U - replace all from cursor to end of text");

 ph(17,"F10 - insert decimal code	Esc - insert control character");

 ph(19,"Control/Q - quit		Control/Z - save & exit");
 ph(20,"Control/E - save & exit in UNIX style");
#endif
#ifdef GERMAN
  ph(2,"Control/T,Home - Textanfang	Control/B - Textende");
  ph(3,"Control/C - Seite runter	Control/R - Seite hoch");
  ph(4,"Control/Y - Zeile loeschen	Control/V - Tastatur umschalten");

  ph(6,"Control/L - Datei laden		Control/S - Datei abspeichern/sichern");

  ph(8,"Control/A - Gebiet markieren (Cursorposition ist das andere Ende");
  ph(9,"Control/W - Gebiet schreiben	Control/G - Gebiet loeschen");
 ph(12,"nimm Control/A, Control/W und Control/L um Bloecke zu kopieren");

 ph(13,"Control/F - finde Zeile		Control/N - finde naechstes Auftreten");
 ph(14,"Control/O - austauschen und naechstes Auftreten finden");
 ph(15,"Control/U - alle Suchzeilen austauschen vom Cursor bis zum 
Textende");

 ph(17,"F10 - Dezimalcode einfuegen	Esc - Steuerzeichen einfuegen");

 ph(18,"Control/Q - Editor verlassen, Text verwerfen");
 ph(19,"Control/Z - Editor verlassen, Text abspeichern");
 ph(20,"Control/E - Editor verlassen, Text im UNIX-Stil abspeichern");
#endif
  if(maxl>33) { hs2(0); hs3(0); }
  else {
#ifdef ENGLISH
 ph(maxl,"press F1 for next help screen");
#endif
#ifdef GERMAN
 ph(maxl,"Druecke F1 fuer naechsten Hilfe-Schirm");
#endif
    if(key()==0) if(key()==59) { cls(); hs2(21); hs3(21); }
    }
  if(key()==0) key();
  escf=0;
  putscr();
  }

void hs2(x) int x; {
#ifdef ENGLISH
 ph(21-x,"F8 - toggle justification	F9 - toggle autoindent");
 ph(22-x,"F6 - set left margin		F7 - set right margin");
 ph(23-x,"F2 - format paragraph		F3 - show control characters");
 ph(24-x,"F4 - show page/line number	F5 - enter page size");
#endif
#ifdef GERMAN
 ph(22-x,"F8 - Autoumbruch umschalten	F9 - automatisches Einruecken 
umschalten");
 ph(23-x,"F6 - linken Rand setzen		F7 - rechten Rand setzen");
 ph(24-x,"F2 - Absatz formatieren		F3 - Controlzeichen zeigen");
 ph(25-x,"F4 - Seiten-/Zeilennr. zeigen	F5 - Seitengroesse eingeben");
#endif
 }

#endif

#ifdef LINUX

#include <fcntl.h>
#include <termios.h>

static int keyfile;
static struct termios t,o;
static int acf;
static char buf[2]={0,0};

int kbhit(void) {
  int i;
  if(buf[1]) return 1;
  i=read(keyfile,buf,1);
  if(i!=-1) buf[1]=1;
  return (i!=-1);
  }

int hCrawcin(void) {
  int i;
  while(kbhit()==0) continue;
  i=(int)*buf; i &= 255;
  buf[1]=0;
  return i;
  }

int vttab[]={63,73<<16,12,127,81<<16,18,3,63,63,63,63,
  59<<16,60<<16,61<<16,62<<16,63<<16,63,
  64<<16,65<<16,66<<16,67<<16,68<<16,63,
  27,127<<16,19,71<<16,63,59<<16,79<<16,63,
  115<<16,116<<16,63<<16,117<<16,63,63,63,63};

int vttab2[]={59<<16,60<<16,61<<16,62<<16,63<<16};

int Crawcin() {
  register int c,h,i;
  int li,co;
  c=hCrawcin();
  switch(c) {
    case 255:
    case 8:     return 127;
    case 10:    return 13;
    case 127:   return 8;
    case 188:   return 124;
    case 171:   return 126;
    case 183:   return '{';
    case 184:   return '[';
    case 185:   return ']';
    case 176:   return '}';
    case 220:   return '\\';
    case 241:   return '@';
    case 237:   return 181;
    default:	return c;
    case 27:	i=hCrawcin();
                if(i=='[' || i=='O') {
                  i=hCrawcin();
                  if(i<='9' && i>='0') {
                    i-='0';
                    while(h=hCrawcin(),h<='9' && h>='0') i=i*10+h-48;
                    if(h=='~') return(vttab[i]);
                    if(h==';') {
                      li=i;
                      co=hCrawcin()-'0';
                      while(h=hCrawcin(),h<='9'&& h>='0') co=co*10+h-48;
                      if(h=='R') {
                        if(co>254) co=254; if(co<3) co=3; if(li<3) li=3; co--; 
li--;
                        if(ll!=co || maxl!=li) { ll=co; maxl=li; return 
(255<<16); }
                        return (254<<16);
                        }
                      return Crawcin();
                      }
                    }
 		  switch(i) {
	  	    default: return(Crawcin());
                    case 70:  return(81<<16);
		    case 65:  return(72<<16);
		    case 66:  return(80<<16);
		    case 67:  return(77<<16);
   		    case 68:  return(75<<16);
		    case 72:  return(73<<16);
	  	    case 90:  return(9);
	  	    case 91:  i=hCrawcin()-65;
	  	              if(i<0 || i>4) return 63;
	  	              return vttab2[i];
                    }
		  }
                else return i;
    }
  }

int ac( i) int i; {
  unsigned char *s,c,ic;
  ic=(unsigned char)i;
  switch(acf) {
    case 1:	s=(unsigned char *)" 'eEaAiIoOuU"; break;
    case 2:	s=(unsigned char *)" `aAeEiIoOuU";   break;
    case 3:	s=(unsigned char *)" ^aAeEiIoOuU";   break;
    case 4:	s=(unsigned char *)" ~aAeEiIoOuUnN]}[{@\\s"; 
break;
    default:	acf=0; return(i);
    }
  acf=0; c=s[1];
  while(*s) { if(*s++==ic) return((int)*s); else s++; }
  exkey=i; return(c);
  }

int key() {
  register long h;
  register int i,j,c;
  if((i=exkey)!=0) { exkey=0; return(i); }
  h=Crawcin();
  i=(int)h&255;
  if(keytab==kt0) {
    if(acf && h!=(255<<16) && h!=(254<<16)) return(ac(i));
    if(i==39)  { acf=1; return(key()); }
    if(i=='`') { acf=2; return(key()); }
    if(i=='^') { acf=3; return(key()); }
    if(h==(127<<16)) { acf=4; return(key()); }
    }
  if(i==28) { exkey=25; return(0); }
  if(i==29) { exkey=16; return(0); }
  if(i) return(i);
  exkey=(int)(h>>16);
  if(exkey==68) {
    escf=1; i=0;
    while(((j=(int)Crawcin())>='0')&&(j<='9')) {
      c=j-'0';
      if((i*10+c)>255) break;
      i*=10; i+=c;
      if(i>25) { exkey=0; return(i&255); }
      }
    exkey=j;
    return(i&255);
    }
  return(0);
  }

void initkey() {
  keyfile=open("/dev/tty",O_NDELAY);
  tcgetattr(keyfile,&t);
  o=t;
  cfmakeraw(&t);
  tcsetattr(keyfile,TCSANOW,&t);
  }

void endekey() {
  tcsetattr(keyfile,TCSANOW,&o);
  close(keyfile);
  }

void help() {
  cls();
  ph(0,open_s2);
#ifdef ENGLISH
  ph(2,"Control/T,Home - top of text	Control/B - bottom of text");
  ph(3,"Control/C - page down		Control/R - page up");
  ph(4,"Control/Y - delete line		Control/V - switch keyboard");

  ph(6,"Control/L - load file		Control/S - save file");

  ph(8,"Control/A - mark area (cursor position is other end)");
  ph(9,"Control/W - write marked area   Control/G - delete marked area");
 ph(12,"use Control/A, Control/W and Control/L to copy or move blocks");

 ph(13,"Control/F - find string		Control/N - find next");
 ph(14,"Control/O - replace and find next");
 ph(15,"Control/U - replace all from cursor to end of text");

 ph(17,"F10 - insert decimal code	F11 - insert control character");

 ph(19,"Control/Q - quit");
 ph(20,"Control/Z - save & exit in MS-DOS style");
 ph(21,"Control/E - save & exit in UNIX style");
#endif
#ifdef GERMAN
  ph(2,"Control/T,Home - Textanfang	Control/B - Textende");
  ph(3,"Control/C - Seite runter	Control/R - Seite hoch");
  ph(4,"Control/Y - Zeile lschen	Control/V - Tastatur umschalten");

  ph(6,"Control/L - Datei laden		Control/D - Datei abspeichern/sichern");

  ph(8,"Control/A - Gebiet markieren (Cursorposition ist das andere Ende");
  ph(9,"Control/W - Gebiet schreiben	Control/G - Gebiet lschen");
 ph(12,"nimm Control/A, Control/W und Control/L um Bloecke zu kopieren");

 ph(13,"Control/F - finde Zeile		Control/N - finde nchstes Auftreten");
 ph(14,"Control/O - austauschen und nchstes Auftreten finden");
 ph(15,"Control/U - alle Suchzeilen austauschen vom Cursor bis zum 
Textende");

 ph(17,"F10 - Dezimalcode einfgen	F11 - Steuerzeichen einfgen");

 ph(18,"Control/Q - Editor verlassen, Text verwerfen");
 ph(19,"Control/Z - Editor verlassen, Text im MS-DOS-Stil abspeichern");
 ph(20,"Control/E - Editor verlassen, Text im UNIX-Stil abspeichern");
#endif
  if(maxl>33) { hs2(0); hs3(0); }
  else {
#ifdef ENGLISH
 ph(maxl,"press F1 for next help screen");
#endif
#ifdef GERMAN
 ph(maxl,"Drcke F1 fr nchsten Hilfe-Schirm");
#endif
    if(key()==0) if(key()==59) { cls(); hs2(21); hs3(21); }
    }
  if(key()==0) key();
  escf=0;
  putscr();
  }

void hs2(x) int x; {
#ifdef ENGLISH
 ph(21-x,"F8 - toggle justification	F9 - toggle autoindent");
 ph(22-x,"F6 - set left margin		F7 - set right margin");
 ph(23-x,"F2 - format paragraph			F3 - show control characters");
 ph(24-x,"F4 - show page/line number	F5 - enter page size");
#endif
#ifdef GERMAN
 ph(22-x,"F8 - Autoumbruch umschalten	F9 - automatisches Einrcken 
umschalten");
 ph(23-x,"F6 - linken Rand setzen		F7 - rechten Rand setzen");
 ph(24-x,"F2 - Absatz formatieren		F3 - Controlzeichen zeigen");
 ph(25-x,"F4 - Seiten-/Zeilennr zeigen	F5 - Seitengre eingeben");
#endif
 }

#endif


