/* EDI_SCR.C */

/* 19-dec-2000 */

/* Author: A.Graf */

#include "edi.h"

/********************************************************************/
/*                                                                  */
/*                bildschirmabhngige Funktionen                    */
/*                                                                  */
/********************************************************************/

#ifdef ST

long VIDPITCH;
int REZ;
char *vidbase;
int oldgr;

void plasm() {
  register unsigned char *dp,*dpi,b,*d;
  register short *h;
  register int c,j,i;

  if(ply>maxl) ply=maxl;
  dpi=(unsigned char *)vidbase+VIDPITCH*10l*ply;
  if(REZ==4) dpi+=4;
  h=(short *)&line[512];
  i=ll; do {
    c=(int)*h++; d=xfont+((c&0x3ff)<<3); dp=dpi;
    if((c&0x6000)!=0) {
      if((c&0x1000)!=0) {
        j=8; do {
          b=*d++;
          b|=b>>1;
          if(j<3) b<<=1;
          if(j>5) b>>=1;
          *dp=b; dp += VIDPITCH;
          } while(--j);
        }
      else {
        j=8; do {
          b=*d++;
          b|=b>>1;
          *dp=b; dp += VIDPITCH;
          } while(--j);
        }
      }
    else {
      if((c&0x1000)!=0) {
        j=8; do {
          b=*d++;
          if(j<3) b<<=1;
          if(j>5) b>>=1;
          *dp=b; dp += VIDPITCH;
          } while(--j);
        }
      else {
        dp[0]  =*d++; dp[VIDPITCH] =*d++;
        dp[VIDPITCH*2]=*d++; dp[VIDPITCH*3]=*d++;
        dp[VIDPITCH*4]=*d++; dp[VIDPITCH*5]=*d++;
        dp[VIDPITCH*6]=*d++; dp[VIDPITCH*7]=*d++;
        }
      }
    dpi[VIDPITCH*8] = c>>15; dpi++;
    if(REZ==4 && (i&1)!=0) dpi+=6;
    } while(--i);
  }

void invcur() {
  register char *v;
  register int count;
  if(cursorx>=ll) cursorx=ll-1;
  v=vidbase+VIDPITCH*10l*cursory+cursorx;
  if(REZ==4) v+=((cursorx&-2)*3)+2;
  for(count=0;count<8;count++) {
    *v ^= 255;
    v += VIDPITCH;
    }
  }

void cls() { Cconout(27); Cconout('E'); }

void initscreen() {
  ll=80; maxl=24;
  oldgr=Getrez();
  if(oldgr==0) Setscreen((void *)-1l,(void *)-1l,1);
  REZ=Getrez(); VIDPITCH=80;
  REZ=4;
  if(REZ>1) maxl=39;
  if(REZ==4) { ll=80; maxl=47; VIDPITCH=320; }
  if(REZ>4) { ll=160; maxl=95; VIDPITCH=160; }
  vidbase=(char *)Logbase();
  Cursconf(0,0);
  }

void endescreen() {
  Cursconf(1,0);
  if(oldgr==0) Setscreen((void *)-1l,(void *)-1l,0);
  }

#endif

#ifdef MS_DOS

int bios(NR,AH,AL,BX,CX,DX) int NR,AH,AL,BX,CX,DX; {
  static union REGS inregs,outregs;
  inregs.h.ah=(char)AH;
  inregs.h.al=(char)AL;
  inregs.x.bx=BX;
  inregs.x.cx=CX;
  inregs.x.dx=DX;
  return(int86(NR,&inregs,&outregs));
  }

void plasm1(void) {
  register unsigned char *dp, *dpi,b,*d;
  register short *h;
  register int c,j,i;

  if(ply>maxl) ply=maxl;
  dpi=(unsigned char *)0xa0000000l+800*ply;
  h=(short *)&line[512];
  i=ll; do {
    c=(int)*h++; d=xfont+((c&0x3ff)<<3); dp=dpi;
    if((c&0x6000)!=0) {
      if((c&0x1000)!=0) {
        j=8; do {
          b=*d++;
          b|=b>>1;
          if(j<3) b<<=1;
          if(j>5) b>>=1;
          *dp=b^invers; dp += 80;
          } while(--j);
        }
      else {
        j=8; do {
          b=*d++;
          b|=b>>1;
          *dp=b^invers; dp += 80;
          } while(--j);
        }
      }
    else {
      if((c&0x1000)!=0) {
        j=8; do {
          b=*d++;
          if(j<3) b<<=1;
          if(j>5) b>>=1;
          *dp=b^invers; dp += 80;
          } while(--j);
        }
      else {
        dp[0]  = *d++^invers; dp[80]  = *d++^invers;
        dp[160]= *d++^invers; dp[240] = *d++^invers;
        dp[320]= *d++^invers; dp[400] = *d++^invers;
        dp[480]= *d++^invers; dp[560]= *d++^invers;
        }
      }
    dpi[640] = (c>>15)^invers; dpi++;
    } while(--i);
  }

void plasm() {
  register unsigned char *dp, *dpi,b,*d;
  register short *h;
  register int c,j,i;

  if(bh==8) { plasm1(); return; }
  if(ply>maxl) ply=maxl;
  dpi=(unsigned char *)0xa0000000l+1600*ply;
  h=(short *)&line[512];
  i=ll; do {
    c=(int)*h++; d=xfont+((c&0x3ff)<<3); dp=dpi;
    if((c&0x6000)!=0) {
      if((c&0x1000)!=0) {
        j=8; do {
          b=*d++;
          b|=b>>1;
          if(j<3) b<<=1;
          if(j>5) b>>=1;
          *dp=b^invers; dp += 80;
          *dp=b^invers; dp += 80;
          } while(--j);
        }
      else {
        j=8; do {
          b=*d++;
          b|=b>>1;
          *dp=b^invers; dp += 80;
          *dp=b^invers; dp += 80;
          } while(--j);
        }
      }
    else {
      if((c&0x1000)!=0) {
        j=8; do {
          b=*d++;
          if(j<3) b<<=1;
          if(j>5) b>>=1;
          *dp=b^invers; dp += 80;
          *dp=b^invers; dp += 80;
          } while(--j);
        }
      else {
        dp[0]  = dp[80]  =*d++^invers; dp[160] = dp[240] =*d++^invers;
        dp[320]= dp[400] =*d++^invers; dp[480] = dp[560] =*d++^invers;
        dp[640]= dp[720] =*d++^invers; dp[800] = dp[880] =*d++^invers;
        dp[960]= dp[1040]=*d++^invers; dp[1120]= dp[1200]=*d++^invers;
        }
      }
    dpi[1280] = dpi[1360] = (c>>15)^invers; dpi++;
    } while(--i);
  }

void invcur() {
  register unsigned char *v;
  register int count;
  if(cursorx>=ll) cursorx=ll-1;
  v=(unsigned char *)0xa0000000l+bh*100*cursory+cursorx;
  count=bh; do { *v ^= 255; v += 80; } while(--count);
  }

void cls() {
  int i;
  long *v,l;
  l=(long)((char)invers);
  v=(long *)0xa0000000l;
  i=ll*24*5;
  do *v++=l; while(--i);
  }

void initscreen() {
  ll=80;
  maxl=47; if(bh==16) maxl=23;
  bios(16,0,18,0,0,0);
  cls();
  }

void endescreen() { bios(16,0,3,0,0,0); }

#endif

#ifdef ELTECIPP

extern int ll;
int lutabb[]={200,60,0};
int lutabf[]={0,0,0};

void plasm() {
  register IBYTE *dp,*dpi,b;
  register short *h;
  register int c,j,i;

  if(ply>maxl) ply=maxl;
  dpi=(IBYTE *)0x90000000+ply*10*IPPPITCH; h=(short *)&line[512];
  i=ll; do {
    c=(int)*h++; dp=dpi;
    if((c&0x1000)!=0) {
      for(j=0;j<8;j++) {
        b=xfont[((c&0x3ff)<<3)+j];
        if((c&0x6000)!=0) b|=b>>1;
        if(j<3) b>>=1;
        if(j>5) b<<=1;
        *dp++=b; b<<=1;
        *dp++=b; b<<=1;
        *dp++=b; b<<=1;
        *dp++=b; b<<=1;
        *dp++=b; b<<=1;
        *dp++=b; b<<=1;
        *dp++=b; b<<=1;
        *dp++=b;
        dp += 1024-8;
      }
    }
    else {
      for(j=0;j<8;j++) {
        b=xfont[((c&0x3ff)<<3)+j];
        if((c&0x6000)!=0) b|=b>>1;
        *dp++=b; b<<=1;
        *dp++=b; b<<=1;
        *dp++=b; b<<=1;
        *dp++=b; b<<=1;
        *dp++=b; b<<=1;
        *dp++=b; b<<=1;
        *dp++=b; b<<=1;
        *dp++=b;
        dp += 1024-8;
        }
      }
    b=c>>8;
    *dp++=b; *dp++=b; *dp++=b; *dp++=b;
    *dp++=b; *dp++=b; *dp++=b; *dp++=b;
    dpi += 8;
    } while(--i);
  }

void invcur() {
  register IBYTE *dp;
  register int j;
  for(j=0;j<9;j++) {
    dp=(IBYTE *)0x90000000+(cursory*10+j)*IPPPITCH+cursorx*8;
    *dp++^=128; *dp++^=128; *dp++^=128; *dp++^=128;
    *dp++^=128; *dp++^=128; *dp++^=128; *dp++^=128;
    }
  }

void cls() {
  register long *p0,i;
  p0=(long *)0x90000000;
  i=0xa0000/4; do *p0++=0; while(--i);
  }

void initscreen() {
  register int i,pfad;
  InitVideo();
  pfad = open( "gedi.dat", S_IREAD);
  if(pfad<0) pfad = open( "/dd/sys/gedi.dat", S_IREAD);
  if (pfad >= 0) ReadSetup(pfad);
  SnapShot(); AssignFrame(1);
  for(i=  0;i<128;i++) SetDClut(i,1,lutabb);
  for(i=128;i<256;i++) SetDClut(i,1,lutabf);
  ll=CurrentWindow[ACQU].SizeX/8;
  maxl=CurrentWindow[ACQU].SizeY/10-1; if(maxl>52) maxl=52;
  }

void endescreen() { cls(); DefaultDClut(); }

#endif

#ifdef ELTECCFG
#define baccol 3
extern int ll;
static COLPIX *screen;

void plasm() {
  register unsigned char *dp,*dpi,b,bc;
  register short *h;
  register int c,j,i;

  if(ply>maxl) ply=maxl;
  bc=baccol; if(ply==maxl) bc=11;
  dpi=(unsigned char *)screen+ply*10*4096+3; h=(short *)&line[512];
  i=ll; do {
    c=(int)*h++; dp=dpi;
    if((c&0x1000)!=0) {
      for(j=0;j<8;j++) {
        b=xfont[((c&0x3ff)<<3)+j];
        if((c&0x6000)!=0) b|=b>>1;
        if(j<3) b>>=1;
        if(j>5) b<<=1;
        if(b&128) *dp=1; else *dp=bc; dp+=4;
        if(b& 64) *dp=1; else *dp=bc; dp+=4;
        if(b& 32) *dp=1; else *dp=bc; dp+=4;
        if(b& 16) *dp=1; else *dp=bc; dp+=4;
        if(b&  8) *dp=1; else *dp=bc; dp+=4;
        if(b&  4) *dp=1; else *dp=bc; dp+=4;
        if(b&  2) *dp=1; else *dp=bc; dp+=4;
        if(b&  1) *dp=1; else *dp=bc;
        dp += 4096-28;
      }
    }
    else {
      for(j=0;j<8;j++) {
        b=xfont[((c&0x3ff)<<3)+j];
        if((c&0x6000)!=0) b|=b>>1;
        if(b&128) *dp=1; else *dp=bc; dp+=4;
        if(b& 64) *dp=1; else *dp=bc; dp+=4;
        if(b& 32) *dp=1; else *dp=bc; dp+=4;
        if(b& 16) *dp=1; else *dp=bc; dp+=4;
        if(b&  8) *dp=1; else *dp=bc; dp+=4;
        if(b&  4) *dp=1; else *dp=bc; dp+=4;
        if(b&  2) *dp=1; else *dp=bc; dp+=4;
        if(b&  1) *dp=1; else *dp=bc;
        dp += 4096-28;
        }
      }
    b=bc; if(c&0x8000) b=1;
    *dp=b; dp+=4; *dp=b; dp+=4; *dp=b; dp+=4; *dp=b; dp+=4;
    *dp=b; dp+=4; *dp=b; dp+=4; *dp=b; dp+=4; *dp=b;
    dpi += 32;
    } while(--i);
  }

void invcur() {
  register unsigned long *dp;
  register int j;
  for(j=0;j<9;j++) {
    dp=(unsigned long *)screen+(cursory*10+j)*1024+cursorx*8;
    *dp++^=1; *dp++^=1; *dp++^=1; *dp++^=1;
    *dp++^=1; *dp++^=1; *dp++^=1; *dp++^=1;
    }
  }

void cls() {
  register long *p0,i;
  p0=(long *)screen;
  i=1024*250l; do *p0++=baccol; while(--i);
  }

void initscreen() {
  InitCFG();
  Interlace(0);
  AcqWindow(0,0,0,0,1);
  screen=DisplayWindow(50,30,720,250,0);
  ll=128;
  maxl=24;
  }

void endescreen() {
  DisplayWindow(0,0,0,0,0);
  ExitCFG();
  }

#endif

#ifdef OS9_VT320SCREEN

#define ll 79

void plasm() {
  register char *h,c;
  register short *s;
  char h1[140];
  register int i;
  s=(short *)&line[512]; h=h1;
  for(i=0;i<ll;i++) {
    c=*s++;
    if(((c&127)<32)&&(c!=0)) c='';
    if((*h++=c)==0) h[-1]=32;
    }
  while(*--h==32) if((long)h<(long)h1) break;
  *++h=0;
  printf("\033[%d;1H%s\033[K",ply+1,h1);
  fflush(stdout);
  }

void invcur() { printf("\033[%d;%dH",cursory+1,cursorx+1); fflush(stdout); }

void cls() { printf("\033[H\033[J"); fflush(stdout); }

void initscreen() { maxl=24; }

void endescreen() {}

#endif

#ifdef VT100SCREEN

static char *normal="\033[0;30;47m";
static char *hell="\033[0;34;47m";
static char *ctrz="\033[0;31;47m";

static void strc(register char *d,register char *s) {
  while((*d++=*s++)!=0) continue;
  }

void plasm() {
  register unsigned char *h,c;
  register short *s;
  unsigned char h1[10240];
  register int i,nor;
  s=(short *)&line[512]; h=h1;
  for(i=0;i<ll;i++) {
    nor=0;
    c=(unsigned char)*s;
    if((*s&0x8000)!=0) { strc((char *)h,ctrz); while(*h) h++; nor=1; }
    if((*s&0x6000)!=0) { strc((char *)h,hell); while(*h) h++; nor=1; }
    if((*h++=c)==0) h[-1]=32;
    s++;
    if(nor!=0) { strc((char *)h,normal); while(*h) h++; }
    }
  while(*--h==32) if((long)h<(long)h1) break;
  *++h=0;
  printf("\033[%d;1H%s\033[K",ply+1,h1);
  fflush(stdout);
  }

void invcur() { printf("\033[%d;%dH",cursory+1,cursorx+1); fflush(stdout); }

void cls() { printf("%s\033[H\033[J",normal); fflush(stdout); }

void initscreen() { ll=79; maxl=24; }

void endescreen() { normal="\033c"; cls(); }

#endif

#ifdef VT52_SCREEN

void plasm() {
  register char *h,c;
  register short *s;
  char h1[400];
  register int i;
  s=(short *)&line[512]; h=h1;
  for(i=0;i<ll;i++) {
    if((*s & 0xf000)!=0) { *h++=27; *h++=112; }
    c=*s;
    if((*h++=c)==0) h[-1]=32;
    if((*s++ & 0xf000)!=0) { *h++=27; *h++=113; }
    }
  while(*--h==32) if((long)h<(long)h1) break;
  *++h=0;
  printf("\033Y%c %s\033K",ply+32,h1);
  fflush(stdout);
  }

void invcur() { printf("\033Y%c%c",cursory+32,cursorx+32); fflush(stdout); }

void cls() { printf("\033H\033J"); fflush(stdout); }

void initscreen() { maxl=24; ll=79; }

void endescreen() {}

#endif

