#!/bin/bash

# Ferninstallation von OpenOffice auf dem
# SuSE Linux Enterprise Server 9

# 26-Jan-2005

INSDIR="/tmp/fernwartung$$"
COMPUTERLIST="computer01 computer02 computer03 computer05 computer06"

mkdir $INSDIR
cd $INSDIR

cp -a /pub/OOo $INSDIR

###############################################################

cat >profile <<EOF
for PAKET in /tmp/OOo/*.rpm
do
rpm -i --force --nodeps --nosignature \$PAKET
done
SuSEconfig
rm -rf /tmp/OOo
logout
EOF

###############################################################

cat >procomputer <<EOF
#!/bin/bash
scp -r $INSDIR/OOo root@\$1:/tmp
>$INSDIR/profile.\$1
scp root@\$1:.profile $INSDIR/profile.\$1
scp $INSDIR/profile root@\$1:.profile
ssh root@\$1
scp $INSDIR/profile.\$1 root@\$1:.profile
rm -f profile.\$1
rm -f \$1
EOF

chmod +x procomputer

###############################################################

for COMPUTER in $COMPUTERLIST
do
>$COMPUTER
$INSDIR/procomputer $COMPUTER &
done

while true
do
FOUND=0
	for COMPUTER in $COMPUTERLIST
	do 
		if [ -f $COMPUTER ] ; then
			echo "`date +%H:%M` $COMPUTER wird noch bearbeitet" 1>&2
			FOUND=1
		fi
	done
	[ $FOUND = 0 ] && break
	sleep 20
done

cd
rm -rf $INSDIR

